/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.csp;

import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.views.csp.CspConfiguration;
import io.reactivex.Flowable;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;

@Filter(value={"${micronaut.views.csp.filter-path:/**}"})
public class CspFilter
implements HttpServerFilter {
    public static final String CSP_HEADER = "Content-Security-Policy";
    public static final String CSP_REPORT_ONLY_HEADER = "Content-Security-Policy-Report-Only";
    public static final String NONCE_PROPERTY = "cspNonce";
    public static final String NONCE_TOKEN = "{#nonceValue}";
    protected final CspConfiguration cspConfiguration;

    public CspFilter(CspConfiguration cspConfiguration) {
        this.cspConfiguration = cspConfiguration;
    }

    @Nullable
    private String nonceValue() {
        return this.cspConfiguration.isNonceEnabled() ? this.cspConfiguration.generateNonce() : null;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        String nonce = this.nonceValue();
        return Flowable.fromPublisher((Publisher)chain.proceed(request.setAttribute((CharSequence)NONCE_PROPERTY, (Object)nonce))).doOnNext(response -> this.cspConfiguration.getPolicyDirectives().map(StringUtils::trimToNull).ifPresent(directives -> {
            String headerValue;
            String header;
            String string = header = this.cspConfiguration.isReportOnly() ? CSP_REPORT_ONLY_HEADER : CSP_HEADER;
            if (directives.contains(NONCE_TOKEN)) {
                if (nonce == null) {
                    throw new IllegalArgumentException("Must enable CSP nonce generation to use '{#nonceValue}' placeholder.");
                }
                headerValue = directives.replace(NONCE_TOKEN, nonce);
            } else {
                headerValue = directives;
            }
            response.getHeaders().add((CharSequence)header, (CharSequence)headerValue);
        }));
    }
}

