/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.model.security;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.utils.SecurityService;
import io.micronaut.views.ModelAndView;
import io.micronaut.views.model.ViewModelProcessor;
import io.micronaut.views.model.security.SecurityViewModelProcessorConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Singleton;

@Requirements(value={@Requires(property="micronaut.security.views-model-decorator.enabled", notEquals="false"), @Requires(beans={SecurityFilter.class, SecurityService.class, SecurityViewModelProcessorConfiguration.class})})
@Singleton
public class SecurityViewModelProcessor
implements ViewModelProcessor {
    private final SecurityService securityService;
    private final SecurityViewModelProcessorConfiguration securityViewModelProcessorConfiguration;

    public SecurityViewModelProcessor(SecurityViewModelProcessorConfiguration securityViewModelProcessorConfiguration, SecurityService securityService) {
        this.securityViewModelProcessorConfiguration = securityViewModelProcessorConfiguration;
        this.securityService = securityService;
    }

    @Override
    public void process(@Nonnull HttpRequest<?> request, @Nonnull ModelAndView<Map<String, Object>> modelAndView) {
        Optional authentication = this.securityService.getAuthentication();
        if (authentication.isPresent()) {
            HashMap<String, Object> securityModel = new HashMap<String, Object>();
            securityModel.put(this.securityViewModelProcessorConfiguration.getPrincipalNameKey(), ((Authentication)authentication.get()).getName());
            securityModel.put(this.securityViewModelProcessorConfiguration.getAttributesKey(), ((Authentication)authentication.get()).getAttributes());
            Map viewModel = modelAndView.getModel().orElseGet(() -> {
                HashMap newModel = new HashMap(1);
                modelAndView.setModel(newModel);
                return newModel;
            });
            viewModel.putIfAbsent(this.securityViewModelProcessorConfiguration.getSecurityKey(), securityModel);
        }
    }
}

