/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.freemarker;

import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.cli.exceptions.ParseException;
import io.micronaut.core.io.Writable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.annotation.Produces;
import io.micronaut.views.ViewUtils;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.freemarker.FreemarkerViewsRendererConfigurationProperties;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Produces(value={"text/html"})
@Requirements(value={@Requires(property="micronaut.views.freemarker.enabled", notEquals="false"), @Requires(classes={Configuration.class})})
@Singleton
public class FreemarkerViewsRenderer
implements ViewsRenderer {
    protected final ViewsConfiguration viewsConfiguration;
    protected final FreemarkerViewsRendererConfigurationProperties freemarkerMicronautConfiguration;
    protected final String extension;

    @Inject
    FreemarkerViewsRenderer(ViewsConfiguration viewsConfiguration, FreemarkerViewsRendererConfigurationProperties freemarkerConfiguration) {
        this.viewsConfiguration = viewsConfiguration;
        this.freemarkerMicronautConfiguration = freemarkerConfiguration;
        this.extension = freemarkerConfiguration.getDefaultExtension();
    }

    @Nonnull
    public Writable render(@Nonnull String viewName, @Nullable Object data) {
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        return writer -> {
            Map context = this.modelOf(data);
            String location = this.viewLocation(viewName);
            Template template = this.freemarkerMicronautConfiguration.getTemplate(location);
            try {
                template.process((Object)context, writer);
            }
            catch (TemplateException e) {
                throw new ViewRenderingException("Error rendering Freemarker view [" + viewName + "]: " + e.getMessage(), (Throwable)e);
            }
        };
    }

    public boolean exists(@Nonnull String view) {
        try {
            this.freemarkerMicronautConfiguration.getTemplate(this.viewLocation(view));
        }
        catch (MalformedTemplateNameException | ParseException e) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private String viewLocation(String name) {
        return ViewUtils.normalizeFile((String)name, (String)this.extension) + "." + this.extension;
    }
}

