/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.freemarker;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.freemarker.FreemarkerViewsRendererConfiguration;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Requires(classes={Configuration.class})
@ConfigurationProperties(value="micronaut.views.freemarker")
public class FreemarkerViewsRendererConfigurationProperties
extends Configuration
implements FreemarkerViewsRendererConfiguration {
    public static final String PREFIX = "micronaut.views.freemarker";
    public static final String DEFAULT_EXTENSION = "ftl";
    public static final boolean DEFAULT_ENABLED = true;
    private boolean enabled = true;
    private String defaultExtension = "ftl";

    public FreemarkerViewsRendererConfigurationProperties(ViewsConfiguration viewsConfiguration, @Property(name="micronaut.views.freemarker.incompatible-improvements") @Nullable String version, @Nullable ClassPathResourceLoader resourceLoader) {
        super(version != null ? new Version(version) : Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        if (resourceLoader != null) {
            this.setClassLoaderForTemplateLoading(resourceLoader.getClassLoader(), "/" + viewsConfiguration.getFolder());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    @Nonnull
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public void setDefaultExtension(String defaultExtension) {
        ArgumentUtils.requireNonNull((String)"defaultExtension", (Object)defaultExtension);
        this.defaultExtension = defaultExtension;
    }

    @Override
    public Version getIncompatibleImprovements() {
        return super.getIncompatibleImprovements();
    }

    public void setIncompatibleImprovements(Version incompatibleImprovements) {
        super.setIncompatibleImprovements(incompatibleImprovements);
    }

    public void setSettings(@MapFormat(keyFormat=StringConvention.UNDER_SCORE_SEPARATED_LOWER_CASE) Properties props) throws TemplateException {
        super.setSettings(props);
    }
}

