/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.soy;

import com.google.template.soy.SoyFileSet;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.TemplateParameters;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.io.Writable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Produces;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.csp.CspConfiguration;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.soy.AppendableToWritable;
import io.micronaut.views.soy.SoyNamingMapProvider;
import io.micronaut.views.soy.SoyViewsRendererConfigurationProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"text/html"})
@Requirements(value={@Requires(property="micronaut.views.soy.engine", notEquals="tofu"), @Requires(property="micronaut.views.soy.enabled", notEquals="false")})
@Singleton
public class SoySauceViewsRenderer
implements ViewsRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(SoySauceViewsRenderer.class);
    private static final String INJECTED_NONCE_PROPERTY = "csp_nonce";
    protected final ViewsConfiguration viewsConfiguration;
    protected final SoyViewsRendererConfigurationProperties soyMicronautConfiguration;
    protected final SoyNamingMapProvider namingMapProvider;
    protected final SoySauce soySauce;
    private final boolean injectNonce;

    @Inject
    SoySauceViewsRenderer(ViewsConfiguration viewsConfiguration, @Nullable CspConfiguration cspConfiguration, @Nullable SoyNamingMapProvider namingMapProvider, SoyViewsRendererConfigurationProperties soyConfiguration) {
        this.viewsConfiguration = viewsConfiguration;
        this.soyMicronautConfiguration = soyConfiguration;
        this.namingMapProvider = namingMapProvider;
        this.injectNonce = cspConfiguration != null && cspConfiguration.isNonceEnabled();
        SoySauce precompiled = soyConfiguration.getCompiledTemplates();
        if (precompiled != null) {
            this.soySauce = precompiled;
        } else {
            LOG.warn("Compiling Soy templates (this may take a moment)...");
            SoyFileSet fileSet = soyConfiguration.getFileSet();
            if (fileSet == null) {
                throw new IllegalStateException("Unable to load Soy templates: no file set, no compiled templates provided.");
            }
            this.soySauce = soyConfiguration.getFileSet().compileTemplates();
        }
    }

    @Nonnull
    public Writable render(@Nonnull String viewName, @Nullable Object data) {
        return this.render(viewName, data, null);
    }

    @Nonnull
    public Writable render(final @Nonnull String viewName, @Nullable Object data, @Nullable HttpRequest<?> request) {
        Optional nonceObj;
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        HashMap<String, String> ijOverlay = new HashMap<String, String>(1);
        Map context = this.modelOf(data);
        SoySauce.Renderer renderer = this.soySauce.newRenderer(new TemplateParameters(){

            public String getTemplateName() {
                return viewName;
            }

            public Map<String, SoyValueProvider> getParamsAsMap() {
                return null;
            }
        });
        renderer.setData(context);
        if (this.injectNonce && request != null && (nonceObj = request.getAttribute((CharSequence)"cspNonce")).isPresent()) {
            String nonceValue = (String)nonceObj.get();
            ijOverlay.put(INJECTED_NONCE_PROPERTY, nonceValue);
        }
        renderer.setIj(ijOverlay);
        if (this.soyMicronautConfiguration.isRenamingEnabled() && this.namingMapProvider != null) {
            SoyCssRenamingMap cssMap = this.namingMapProvider.cssRenamingMap();
            SoyIdRenamingMap idMap = this.namingMapProvider.idRenamingMap();
            if (cssMap != null) {
                renderer.setCssRenamingMap(cssMap);
            }
            if (idMap != null) {
                renderer.setXidRenamingMap(idMap);
            }
        }
        try {
            AppendableToWritable target = new AppendableToWritable();
            SoySauce.WriteContinuation state = renderer.renderHtml((AdvisingAppendable)target);
            block9: while (state.result().type() != RenderResult.Type.DONE) {
                switch (state.result().type()) {
                    case DONE: {
                        continue block9;
                    }
                    case DETACH: {
                        state.result().future().get();
                        state = state.continueRender();
                        continue block9;
                    }
                    case LIMITED: {
                        continue block9;
                    }
                }
            }
            return target;
        }
        catch (IOException e) {
            throw new ViewRenderingException("Error rendering Soy Sauce view [" + viewName + "]: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException ixe) {
            throw new ViewRenderingException("Interrupted while rendering Soy Sauce view [" + viewName + "]: " + ixe.getMessage(), (Throwable)ixe);
        }
        catch (ExecutionException exe) {
            throw new ViewRenderingException("Execution error while rendering Soy Sauce view [" + viewName + "]: " + exe.getMessage(), (Throwable)exe);
        }
    }

    public boolean exists(@Nonnull String view) {
        return this.soySauce.hasTemplate(view);
    }
}

