/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.soy;

import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.SoyTofuException;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.io.Writable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.annotation.Produces;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.soy.AppendableToWritable;
import io.micronaut.views.soy.SoyViewsRendererConfigurationProperties;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Produces(value={"text/html"})
@Requirements(value={@Requires(property="micronaut.views.soy.engine", notEquals="sauce"), @Requires(classes={SoyTofu.class})})
@Singleton
@Deprecated
public class SoyTofuViewsRenderer
implements ViewsRenderer {
    protected final ViewsConfiguration viewsConfiguration;
    protected final SoyViewsRendererConfigurationProperties soyMicronautConfiguration;
    protected final SoyTofu soyTofu;

    @Inject
    SoyTofuViewsRenderer(ViewsConfiguration viewsConfiguration, SoyViewsRendererConfigurationProperties soyConfiguration) {
        this.viewsConfiguration = viewsConfiguration;
        this.soyMicronautConfiguration = soyConfiguration;
        this.soyTofu = soyConfiguration.getFileSet().compileToTofu();
    }

    @Nonnull
    public Writable render(@Nonnull String viewName, @Nullable Object data) {
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        Map context = this.modelOf(data);
        SoyTofu.Renderer renderer = this.soyTofu.newRenderer(viewName);
        renderer.setData(context);
        try {
            AppendableToWritable target = new AppendableToWritable();
            renderer.renderHtml((Appendable)target);
            return target;
        }
        catch (SoyTofuException e) {
            throw new ViewRenderingException("Error rendering Soy Tofu view [" + viewName + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean exists(@Nonnull String view) {
        return this.soyTofu.hasTemplate(view);
    }
}

