/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.velocity;

import io.micronaut.core.io.Writable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.annotation.Produces;
import io.micronaut.views.ViewUtils;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.velocity.VelocityViewsRendererConfiguration;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

@Produces(value={"text/html"})
@Singleton
public class VelocityViewsRenderer
implements ViewsRenderer {
    protected final VelocityEngine velocityEngine;
    protected final ViewsConfiguration viewsConfiguration;
    protected final VelocityViewsRendererConfiguration velocityConfiguration;
    protected final String folder;

    @Deprecated
    VelocityViewsRenderer(ViewsConfiguration viewsConfiguration, VelocityViewsRendererConfiguration velocityConfiguration) {
        this.viewsConfiguration = viewsConfiguration;
        this.velocityConfiguration = velocityConfiguration;
        this.velocityEngine = this.initializeVelocityEngine();
        this.folder = viewsConfiguration.getFolder();
    }

    @Inject
    VelocityViewsRenderer(ViewsConfiguration viewsConfiguration, VelocityViewsRendererConfiguration velocityConfiguration, VelocityEngine velocityEngine) {
        this.viewsConfiguration = viewsConfiguration;
        this.velocityConfiguration = velocityConfiguration;
        this.velocityEngine = velocityEngine;
        this.folder = viewsConfiguration.getFolder();
    }

    @Nonnull
    public Writable render(@Nonnull String view, @Nullable Object data) {
        ArgumentUtils.requireNonNull((String)"view", (Object)view);
        return writer -> {
            Map context = this.modelOf(data);
            VelocityContext velocityContext = new VelocityContext(context);
            this.render(view, velocityContext, StandardCharsets.UTF_8.name(), writer);
        };
    }

    public void render(@Nonnull String view, VelocityContext context, String encoding, Writer writer) {
        String viewName = this.viewName(view);
        try {
            this.velocityEngine.mergeTemplate(viewName, encoding, (Context)context, writer);
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException e) {
            throw new ViewRenderingException("Error rendering Velocity view [" + viewName + "]: " + e.getMessage(), e);
        }
    }

    public boolean exists(@Nonnull String viewName) {
        try {
            this.velocityEngine.getTemplate(this.viewName(viewName));
        }
        catch (ParseErrorException | ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    private VelocityEngine initializeVelocityEngine() {
        Properties p = new Properties();
        p.setProperty("resource.loader", "class");
        p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        return new VelocityEngine(p);
    }

    private String viewName(String name) {
        return this.folder + ViewUtils.normalizeFile((String)name, (String)this.extension()) + "." + this.extension();
    }

    private String extension() {
        return this.velocityConfiguration.getDefaultExtension();
    }
}

