/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.io.Writable;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.views.ModelAndView;
import io.micronaut.views.View;
import io.micronaut.views.ViewsFilterOrderProvider;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.web.router.qualifier.ProducesMediaTypeQualifier;
import io.reactivex.Flowable;
import java.util.Optional;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={ViewsRenderer.class})
@Filter(value={"/**"})
public class ViewsFilter
implements HttpServerFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ViewsFilter.class);
    protected final Integer order;
    protected final BeanLocator beanLocator;

    public ViewsFilter(BeanLocator beanLocator, @Nullable ViewsFilterOrderProvider viewsFilterOrderProvider) {
        this.beanLocator = beanLocator;
        this.order = viewsFilterOrderProvider != null ? Integer.valueOf(viewsFilterOrderProvider.getOrder()) : Integer.valueOf(0);
    }

    public int getOrder() {
        return this.order;
    }

    public final Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        return Flowable.fromPublisher((Publisher)chain.proceed(request)).switchMap(response -> {
            MediaType type;
            Optional optionalViewsRenderer;
            Object body;
            AnnotationMetadata route;
            Optional<String> optionalView;
            Optional routeMatch = response.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, AnnotationMetadata.class);
            if (routeMatch.isPresent() && (optionalView = this.resolveView(route = (AnnotationMetadata)routeMatch.get(), body = response.body())).isPresent() && (optionalViewsRenderer = this.beanLocator.findBean(ViewsRenderer.class, (Qualifier)new ProducesMediaTypeQualifier(type = route.getValue(Produces.class, MediaType.class).orElse(route.getValue(View.class).isPresent() || body instanceof ModelAndView ? MediaType.TEXT_HTML_TYPE : MediaType.APPLICATION_JSON_TYPE)))).isPresent()) {
                String view;
                ViewsRenderer viewsRenderer = (ViewsRenderer)optionalViewsRenderer.get();
                if (viewsRenderer.exists(view = optionalView.get())) {
                    Object model = this.resolveModel(body);
                    Writable writable = viewsRenderer.render(view, model);
                    response.contentType(type);
                    response.body((Object)writable);
                    return Flowable.just((Object)response);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("view {} not found ", (Object)view);
                }
                return Flowable.just((Object)HttpResponse.notFound());
            }
            return Flowable.just((Object)response);
        });
    }

    protected Object resolveModel(Object responseBody) {
        if (responseBody instanceof ModelAndView) {
            return ((ModelAndView)responseBody).getModel().orElse(null);
        }
        return responseBody;
    }

    protected Optional<String> resolveView(AnnotationMetadata route, Object responseBody) {
        Optional optionalViewName = route.getValue(View.class);
        if (optionalViewName.isPresent()) {
            return Optional.of((String)optionalViewName.get());
        }
        if (responseBody instanceof ModelAndView) {
            return ((ModelAndView)responseBody).getView();
        }
        return Optional.empty();
    }
}

