/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.annotation.Produces;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.handlebars.HandlebarsViewsRendererConfiguration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Produces(value={"text/html"})
@Requirements(value={@Requires(property="micronaut.views.handlebars.enabled", notEquals="false"), @Requires(classes={Handlebars.class})})
@Singleton
public class HandlebarsViewsRenderer
implements ViewsRenderer {
    protected final ViewsConfiguration viewsConfiguration;
    protected final ResourceLoader resourceLoader;
    protected HandlebarsViewsRendererConfiguration handlebarsViewsRendererConfiguration;
    protected Handlebars handlebars = new Handlebars();
    protected String folder;

    public HandlebarsViewsRenderer(ViewsConfiguration viewsConfiguration, ClassPathResourceLoader resourceLoader, HandlebarsViewsRendererConfiguration handlebarsViewsRendererConfiguration) {
        this.viewsConfiguration = viewsConfiguration;
        this.resourceLoader = resourceLoader;
        this.handlebarsViewsRendererConfiguration = handlebarsViewsRendererConfiguration;
        this.folder = this.normalizeFolder(viewsConfiguration.getFolder());
    }

    @Override
    @Nonnull
    public Writable render(@Nonnull String viewName, @Nullable Object data) {
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        return writer -> {
            String location = this.viewLocation(viewName);
            try {
                Template template = this.handlebars.compile(location);
                template.apply(data, writer);
            }
            catch (Throwable e) {
                throw new ViewRenderingException("Error rendering Handlebars view [" + viewName + "]: " + e.getMessage(), e);
            }
        };
    }

    @Override
    public boolean exists(@Nonnull String viewName) {
        if (viewName == null) {
            return false;
        }
        String location = this.viewLocation(viewName) + "." + this.extension();
        return this.resourceLoader.getResource(location).isPresent();
    }

    private String viewLocation(String name) {
        return this.folder + this.normalizeFile(name, this.extension());
    }

    private String extension() {
        return this.handlebarsViewsRendererConfiguration.getDefaultExtension();
    }
}

