/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.thymeleaf;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.annotation.Produces;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.thymeleaf.ThymeleafViewsRendererConfiguration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.exceptions.TemplateEngineException;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Produces(value={"text/html"})
@Requirements(value={@Requires(property="micronaut.views.thymeleaf.enabled", notEquals="false"), @Requires(classes={TemplateEngine.class})})
@Singleton
public class ThymeleafViewsRenderer
implements ViewsRenderer {
    protected final ClassLoaderTemplateResolver templateResolver;
    protected final TemplateEngine engine;
    protected ResourceLoader resourceLoader;

    public ThymeleafViewsRenderer(ViewsConfiguration viewsConfiguration, ThymeleafViewsRendererConfiguration thConfiguration, ClassPathResourceLoader resourceLoader) {
        this.templateResolver = this.initializeTemplateResolver(viewsConfiguration, thConfiguration);
        this.resourceLoader = resourceLoader;
        this.engine = this.initializeTemplateEngine();
    }

    @Override
    @Nonnull
    public Writable render(@Nonnull String viewName, @Nullable Object data) {
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        return writer -> {
            Context context = new Context(Locale.US, this.variables(data));
            try {
                this.engine.process(viewName, (IContext)context, writer);
            }
            catch (TemplateEngineException e) {
                throw new ViewRenderingException("Error rendering Thymeleaf view [" + viewName + "]: " + e.getMessage(), e);
            }
        };
    }

    @Override
    public boolean exists(@Nonnull String viewName) {
        String location = this.viewLocation(viewName);
        return this.resourceLoader.getResourceAsStream(location).isPresent();
    }

    private TemplateEngine initializeTemplateEngine() {
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)this.templateResolver);
        return engine;
    }

    private ClassLoaderTemplateResolver initializeTemplateResolver(ViewsConfiguration viewsConfiguration, ThymeleafViewsRendererConfiguration thConfiguration) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setPrefix(this.normalizeFolder(viewsConfiguration.getFolder()));
        templateResolver.setCharacterEncoding(thConfiguration.getCharacterEncoding());
        templateResolver.setTemplateMode(thConfiguration.getTemplateMode());
        templateResolver.setSuffix(thConfiguration.getSuffix());
        templateResolver.setForceSuffix(thConfiguration.getForceSuffix());
        templateResolver.setForceTemplateMode(thConfiguration.getForceTemplateMode());
        templateResolver.setCacheTTLMs(thConfiguration.getCacheTTLMs());
        templateResolver.setCheckExistence(thConfiguration.getCheckExistence());
        templateResolver.setCacheable(thConfiguration.getCacheable());
        return templateResolver;
    }

    private Map<String, Object> variables(@Nullable Object data) {
        if (data == null) {
            return new HashMap<String, Object>();
        }
        if (data instanceof Map) {
            return (Map)data;
        }
        return BeanMap.of((Object)data);
    }

    private String viewLocation(String name) {
        return this.templateResolver.getPrefix() + this.normalizeFile(name, this.templateResolver.getSuffix()) + this.templateResolver.getSuffix();
    }
}

