/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.thymeleaf;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.StringUtils;
import io.micronaut.views.thymeleaf.ThymeleafViewsRendererConfiguration;
import java.time.Duration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;

@Requires(classes={TemplateEngine.class})
@ConfigurationProperties(value="micronaut.views.thymeleaf")
public class ThymeleafViewsRendererConfigurationProperties
implements ThymeleafViewsRendererConfiguration {
    public static final String PREFIX = "micronaut.views.thymeleaf";
    public static final String DEFAULT_SUFFIX = ".html";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final boolean DEFAULT_FORCESUFFIX = false;
    public static final boolean DEFAULT_FORCETEMPLATEMODE = false;
    private boolean enabled = true;
    private String characterEncoding = "UTF-8";
    private TemplateMode templateMode = AbstractConfigurableTemplateResolver.DEFAULT_TEMPLATE_MODE;
    private String suffix = ".html";
    private boolean forceSuffix = false;
    private boolean forceTemplateMode = false;
    private boolean cacheable = true;
    private Long cacheTTLMs = AbstractConfigurableTemplateResolver.DEFAULT_CACHE_TTL_MS;
    private boolean checkExistence = false;

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public TemplateMode getTemplateMode() {
        return this.templateMode;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public boolean getForceSuffix() {
        return this.forceSuffix;
    }

    @Override
    public boolean getForceTemplateMode() {
        return this.forceTemplateMode;
    }

    @Override
    public Long getCacheTTLMs() {
        return this.cacheTTLMs;
    }

    @Override
    public boolean getCheckExistence() {
        return this.checkExistence;
    }

    @Override
    public boolean getCacheable() {
        return this.cacheable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCharacterEncoding(String characterEncoding) {
        if (StringUtils.isNotEmpty((CharSequence)characterEncoding)) {
            this.characterEncoding = characterEncoding;
        }
    }

    public void setTemplateMode(TemplateMode templateMode) {
        if (templateMode != null) {
            this.templateMode = templateMode;
        }
    }

    public void setSuffix(String suffix) {
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            this.suffix = suffix;
        }
    }

    public void setForceSuffix(boolean forceSuffix) {
        this.forceSuffix = forceSuffix;
    }

    public void setForceTemplateMode(boolean forceTemplateMode) {
        this.forceTemplateMode = forceTemplateMode;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public void setCacheTTLMs(long cacheTTLMs) {
        this.cacheTTLMs = cacheTTLMs;
    }

    public void setCacheTTL(Duration duration) {
        if (duration != null) {
            this.cacheTTLMs = duration.toMillis();
        }
    }

    public void setCheckExistence(boolean checkExistence) {
        this.checkExistence = checkExistence;
    }
}

