/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.velocity;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.io.Writable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.annotation.Produces;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.velocity.VelocityViewsRendererConfiguration;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

@Produces(value={"text/html"})
@Requirements(value={@Requires(property="micronaut.views.velocity.enabled", notEquals="false"), @Requires(classes={VelocityEngine.class})})
@Singleton
public class VelocityViewsRenderer
implements ViewsRenderer {
    protected final VelocityEngine velocityEngine;
    protected final ViewsConfiguration viewsConfiguration;
    protected final VelocityViewsRendererConfiguration velocityConfiguration;
    protected final String folder;

    VelocityViewsRenderer(ViewsConfiguration viewsConfiguration, VelocityViewsRendererConfiguration velocityConfiguration) {
        this.viewsConfiguration = viewsConfiguration;
        this.velocityConfiguration = velocityConfiguration;
        this.velocityEngine = this.initializeVelocityEngine();
        this.folder = this.normalizeFolder(viewsConfiguration.getFolder());
    }

    @Override
    @Nonnull
    public Writable render(@Nonnull String view, @Nullable Object data) {
        ArgumentUtils.requireNonNull((String)"view", (Object)view);
        return writer -> {
            Map<String, Object> context = this.context(data);
            VelocityContext velocityContext = new VelocityContext(context);
            String viewName = this.viewName(view);
            try {
                this.velocityEngine.mergeTemplate(viewName, StandardCharsets.UTF_8.name(), (Context)velocityContext, writer);
            }
            catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException e) {
                throw new ViewRenderingException("Error rendering Velocity view [" + viewName + "]: " + e.getMessage(), e);
            }
        };
    }

    @Override
    public boolean exists(@Nonnull String viewName) {
        try {
            this.velocityEngine.getTemplate(this.viewName(viewName));
        }
        catch (ParseErrorException | ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    private VelocityEngine initializeVelocityEngine() {
        Properties p = new Properties();
        p.setProperty("resource.loader", "class");
        p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        return new VelocityEngine(p);
    }

    private Map<String, Object> context(@Nullable Object data) {
        if (data == null) {
            return new HashMap<String, Object>();
        }
        if (data instanceof Map) {
            return (Map)data;
        }
        return BeanMap.of((Object)data);
    }

    private String viewName(String name) {
        return this.folder + this.normalizeFile(name, this.extension()) + "." + this.extension();
    }

    private String extension() {
        return this.velocityConfiguration.getDefaultExtension();
    }
}

