/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.websocket.interceptor;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Produces;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.exceptions.WebSocketClientException;
import io.micronaut.websocket.interceptor.WebSocketSessionAware;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Future;

@Prototype
public class ClientWebSocketInterceptor
implements MethodInterceptor<Object, Object> {
    private WebSocketSession webSocketSession;

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Object o;
        Object[] values;
        Class declaringType = context.getDeclaringType();
        if (declaringType == WebSocketSessionAware.class && ArrayUtils.isNotEmpty((Object[])(values = context.getParameterValues())) && (o = values[0]) instanceof WebSocketSession) {
            this.webSocketSession = (WebSocketSession)o;
            return null;
        }
        if (declaringType == Closeable.class || declaringType == AutoCloseable.class) {
            if (this.webSocketSession != null) {
                this.webSocketSession.close();
            }
            return null;
        }
        String methodName = context.getMethodName();
        if (methodName.startsWith("send") || methodName.startsWith("broadcast")) {
            MediaType mediaType = context.stringValue(Produces.class).map(MediaType::new).orElse(MediaType.APPLICATION_JSON_TYPE);
            this.validateSession();
            Class javaReturnType = context.getReturnType().getType();
            if (Void.TYPE == javaReturnType) {
                Object[] parameterValues = context.getParameterValues();
                switch (parameterValues.length) {
                    case 0: {
                        throw new IllegalArgumentException("At least 1 parameter is required to a send method");
                    }
                    case 1: {
                        Object v = parameterValues[0];
                        if (v == null) {
                            throw new IllegalArgumentException("Parameter cannot be null");
                        }
                        this.webSocketSession.sendSync(v, mediaType);
                        return null;
                    }
                }
                Map map = context.getParameterValueMap();
                this.webSocketSession.sendSync(map, mediaType);
            } else {
                if (Future.class.isAssignableFrom(javaReturnType)) {
                    Object[] parameterValues = context.getParameterValues();
                    switch (parameterValues.length) {
                        case 0: {
                            throw new IllegalArgumentException("At least 1 parameter is required to a send method");
                        }
                        case 1: {
                            Object v = parameterValues[0];
                            if (v == null) {
                                throw new IllegalArgumentException("Parameter cannot be null");
                            }
                            return this.webSocketSession.sendAsync(v, mediaType);
                        }
                    }
                    Map map = context.getParameterValueMap();
                    return this.webSocketSession.sendAsync(map, mediaType);
                }
                if (Publishers.isConvertibleToPublisher((Class)javaReturnType)) {
                    Object[] parameterValues = context.getParameterValues();
                    switch (parameterValues.length) {
                        case 0: {
                            throw new IllegalArgumentException("At least 1 parameter is required to a send method");
                        }
                        case 1: {
                            Object v = parameterValues[0];
                            if (v == null) {
                                throw new IllegalArgumentException("Parameter cannot be null");
                            }
                            return Publishers.convertPublisher(this.webSocketSession.send(v, mediaType), (Class)javaReturnType);
                        }
                    }
                    Map map = context.getParameterValueMap();
                    return Publishers.convertPublisher(this.webSocketSession.send(map, mediaType), (Class)javaReturnType);
                }
            }
        }
        return context.proceed();
    }

    private void validateSession() {
        if (this.webSocketSession == null || !this.webSocketSession.isOpen()) {
            throw new WebSocketClientException("No available and open WebSocket session");
        }
    }
}

