/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.websocket;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.websocket.WebSocketClientFactoryResolver;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.reactivestreams.Publisher;

public interface WebSocketClient
extends AutoCloseable {
    public static final String SCHEME_WS = "ws";
    public static final String SCHEME_WSS = "wss";

    public <T extends AutoCloseable> Publisher<T> connect(Class<T> var1, MutableHttpRequest<?> var2);

    public <T extends AutoCloseable> Publisher<T> connect(Class<T> var1, Map<String, Object> var2);

    @Override
    public void close();

    default public <T extends AutoCloseable> Publisher<T> connect(Class<T> clientEndpointType, String uri) {
        return this.connect(clientEndpointType, URI.create(uri));
    }

    default public <T extends AutoCloseable> Publisher<T> connect(Class<T> clientEndpointType, URI uri) {
        return this.connect(clientEndpointType, HttpRequest.GET((URI)uri));
    }

    public static WebSocketClient create(@Nullable URL url) {
        return WebSocketClientFactoryResolver.getFactory().createWebSocketClient(url);
    }

    public static WebSocketClient create(@Nullable URL url, HttpClientConfiguration configuration) {
        return WebSocketClientFactoryResolver.getFactory().createWebSocketClient(url, configuration);
    }
}

