/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.websocket;

import io.micronaut.core.annotation.Internal;
import io.micronaut.websocket.WebSocketClientFactory;
import java.util.Iterator;
import java.util.ServiceLoader;

@Internal
final class WebSocketClientFactoryResolver {
    private static volatile WebSocketClientFactory factory;

    WebSocketClientFactoryResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WebSocketClientFactory getFactory() {
        if (factory != null) return factory;
        Class<WebSocketClientFactoryResolver> clazz = WebSocketClientFactoryResolver.class;
        synchronized (WebSocketClientFactoryResolver.class) {
            if (factory != null) return factory;
            factory = WebSocketClientFactoryResolver.resolveClientFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    private static WebSocketClientFactory resolveClientFactory() {
        Iterator<WebSocketClientFactory> i = ServiceLoader.load(WebSocketClientFactory.class).iterator();
        if (i.hasNext()) {
            return i.next();
        }
        throw new IllegalStateException("No HttpClientFactory present on classpath, cannot create client");
    }
}

