/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.websocket.interceptor;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Produces;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.exceptions.WebSocketClientException;
import io.micronaut.websocket.interceptor.WebSocketSessionAware;
import java.io.Closeable;

@Prototype
public class ClientWebSocketInterceptor
implements MethodInterceptor<Object, Object> {
    private final ConversionService conversionService;
    private WebSocketSession webSocketSession;

    public ClientWebSocketInterceptor(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Object o;
        Object[] values;
        Class declaringType = context.getDeclaringType();
        if (declaringType == WebSocketSessionAware.class && ArrayUtils.isNotEmpty((Object[])(values = context.getParameterValues())) && (o = values[0]) instanceof WebSocketSession) {
            WebSocketSession session;
            this.webSocketSession = session = (WebSocketSession)o;
            return null;
        }
        if (declaringType == Closeable.class || declaringType == AutoCloseable.class) {
            if (this.webSocketSession != null) {
                this.webSocketSession.close();
            }
            return null;
        }
        String methodName = context.getMethodName();
        if (methodName.startsWith("send") || methodName.startsWith("broadcast")) {
            MediaType mediaType = context.stringValue(Produces.class).map(MediaType::of).orElse(MediaType.APPLICATION_JSON_TYPE);
            this.validateSession();
            InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
            Class javaReturnType = context.getReturnType().getType();
            if (interceptedMethod.resultType() == InterceptedMethod.ResultType.SYNCHRONOUS && javaReturnType != Void.TYPE) {
                return context.proceed();
            }
            try {
                Object[] parameterValues = context.getParameterValues();
                switch (parameterValues.length) {
                    case 0: {
                        throw new IllegalArgumentException("At least 1 parameter is required to a send method");
                    }
                    case 1: {
                        Object value = parameterValues[0];
                        if (value == null) {
                            throw new IllegalArgumentException("Parameter cannot be null");
                        }
                        return this.send(interceptedMethod, value, mediaType);
                    }
                }
                return this.send(interceptedMethod, context.getParameterValueMap(), mediaType);
            }
            catch (Exception e) {
                return interceptedMethod.handleException(e);
            }
        }
        return context.proceed();
    }

    private Object send(InterceptedMethod interceptedMethod, Object message, MediaType mediaType) {
        switch (interceptedMethod.resultType()) {
            case COMPLETION_STAGE: {
                return interceptedMethod.handleResult(this.webSocketSession.sendAsync(message, mediaType));
            }
            case PUBLISHER: {
                return interceptedMethod.handleResult(this.webSocketSession.send(message, mediaType));
            }
            case SYNCHRONOUS: {
                this.webSocketSession.sendSync(message, mediaType);
                return null;
            }
        }
        return interceptedMethod.unsupported();
    }

    private void validateSession() {
        if (this.webSocketSession == null || !this.webSocketSession.isOpen()) {
            throw new WebSocketClientException("No available and open WebSocket session");
        }
    }
}

