/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.microstream.annotations;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.microstream.annotations.Store;
import io.micronaut.microstream.annotations.StoringStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public final class StoreAnnotationMapperUtils {
    private static final String STRATEGY = "strategy";
    private static final String NAME = "name";

    private StoreAnnotationMapperUtils() {
    }

    @NonNull
    public static AnnotationValueBuilder<Store> annotationValueBuilder(@NonNull AnnotationValue<?> annotation) {
        StoringStrategy storingStrategy = annotation.enumValue(STRATEGY, StoringStrategy.class).orElse(StoringStrategy.LAZY);
        Optional name = annotation.get((CharSequence)NAME, String.class);
        AnnotationValueBuilder builder = AnnotationValue.builder(Store.class).member(STRATEGY, (Enum)storingStrategy);
        if (name.isPresent()) {
            builder = builder.member(NAME, (String)name.get());
        }
        return builder;
    }

    @NonNull
    public static List<AnnotationValue<?>> map(@NonNull AnnotationValue<?> annotation, @NonNull Consumer<AnnotationValueBuilder<Store>> builderConsumer) {
        AnnotationValueBuilder<Store> builder = StoreAnnotationMapperUtils.annotationValueBuilder(annotation);
        builderConsumer.accept(builder);
        ArrayList annotationValues = new ArrayList(1);
        annotationValues.add(builder.build());
        return annotationValues;
    }
}

