/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.microstream.cache;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.microstream.cache.MicroStreamSyncCache;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutorService;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import one.microstream.cache.types.CacheConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class CacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CacheFactory.class);
    private static final String MICROSTREAM_CACHING_PROVIDER = "one.microstream.cache.types.CachingProvider";
    private final CacheManager manager;
    private final ConversionService<?> conversionService;

    public CacheFactory(ConversionService<?> conversionService) {
        this.conversionService = conversionService;
        this.manager = Caching.getCachingProvider((String)MICROSTREAM_CACHING_PROVIDER).getCacheManager();
    }

    @Singleton
    @Bean(preDestroy="close")
    @EachBean(value=CacheConfiguration.Builder.class)
    public <K, V> MicroStreamSyncCache<K, V> createCache(@Parameter String name, CacheConfiguration.Builder<K, V> cacheConfigurationBuilder, @Named(value="io") ExecutorService executorService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating cache: {}", (Object)name);
        }
        return new MicroStreamSyncCache(this.manager.createCache(name, (Configuration)cacheConfigurationBuilder.build()), this.conversionService, executorService);
    }
}

