/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.microstream.cache;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.microstream.cache.ExpiryPolicyFactory;
import io.micronaut.microstream.cache.MicroStreamCacheConfiguration;
import jakarta.inject.Singleton;
import java.util.Optional;
import one.microstream.cache.types.CacheConfiguration;
import one.microstream.cache.types.CacheConfigurationBuilderConfigurationBased;
import one.microstream.configuration.types.Configuration;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;
import one.microstream.storage.types.StorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class CacheConfigurationFactory<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CacheConfigurationFactory.class);
    private final BeanContext beanContext;

    public CacheConfigurationFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @EachBean(value=MicroStreamCacheConfiguration.class)
    @Singleton
    public CacheConfiguration.Builder<K, V> createCacheConfigurationProvider(MicroStreamCacheConfiguration<K, V> cacheConfiguration) {
        if (!cacheConfiguration.isEnabled()) {
            throw new DisabledBeanException("microstream cache " + cacheConfiguration.getName() + " is disabled");
        }
        EmbeddedStorageManager embeddedStorageManager = this.findStorageManager(cacheConfiguration).filter(EmbeddedStorageManager.class::isInstance).orElse(null);
        CacheConfiguration.Builder cacheConfigurationBuilder = embeddedStorageManager == null ? CacheConfiguration.Builder(cacheConfiguration.getKeyType(), cacheConfiguration.getValueType()) : CacheConfiguration.Builder(cacheConfiguration.getKeyType(), cacheConfiguration.getValueType(), (String)cacheConfiguration.getName(), (EmbeddedStorageManager)embeddedStorageManager);
        CacheConfiguration.Builder builder = CacheConfigurationBuilderConfigurationBased.New().buildCacheConfiguration(this.createConfiguration(cacheConfiguration), cacheConfigurationBuilder);
        this.findExpiryPolicyFactory(cacheConfiguration).ifPresent(expiryPolicyFactory -> builder.expiryPolicyFactory(expiryPolicyFactory.getFactory()));
        return builder;
    }

    @NonNull
    private Optional<StorageManager> findStorageManager(MicroStreamCacheConfiguration<K, V> cacheConfiguration) {
        return Optional.ofNullable(cacheConfiguration.getStorage()).flatMap(storageNameQualifier -> {
            if (LOG.isWarnEnabled() && !this.beanContext.containsBean(StorageManager.class, Qualifiers.byName((String)storageNameQualifier))) {
                LOG.warn("No Storage Manager qualified by name {}", storageNameQualifier);
            }
            return this.beanContext.findBean(StorageManager.class, Qualifiers.byName((String)storageNameQualifier));
        });
    }

    @NonNull
    private Configuration createConfiguration(@NonNull MicroStreamCacheConfiguration<K, V> cacheConfiguration) {
        Configuration.Builder configurationBuilder = Configuration.Builder();
        this.booleanString(cacheConfiguration.isReadThrough()).ifPresent(b -> configurationBuilder.set("read-through", b));
        this.booleanString(cacheConfiguration.isWriteThrough()).ifPresent(b -> configurationBuilder.set("write-through", b));
        this.booleanString(cacheConfiguration.isStoreByValue()).ifPresent(b -> configurationBuilder.set("store-by-value", b));
        this.booleanString(cacheConfiguration.isStatisticsEnabled()).ifPresent(b -> configurationBuilder.set("statistics-enabled", b));
        this.booleanString(cacheConfiguration.isManagementEnabled()).ifPresent(b -> configurationBuilder.set("management-enabled", b));
        return configurationBuilder.buildConfiguration();
    }

    @NonNull
    private Optional<ExpiryPolicyFactory> findExpiryPolicyFactory(@NonNull Named named) {
        return this.beanContext.findBean(ExpiryPolicyFactory.class, Qualifiers.byName((String)named.getName()));
    }

    @NonNull
    private Optional<String> booleanString(Boolean value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value != false ? "true" : "false");
    }
}

