/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.microstream.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import io.micronaut.inject.BeanDefinition;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import one.microstream.storage.types.StorageManager;

@Singleton
@RequiresMetrics
@Requirements(value={@Requires(property="micronaut.metrics.binders.microstream.enabled", value="true", defaultValue="true"), @Requires(classes={MeterBinder.class})})
public class MicroStreamMetricsBinder
implements MeterBinder {
    public static final String MICROSTREAM_METRIC_PREFIX = "microstream";
    private static final String SUFFIX_TOTAL_DATA_LENGTH = "totalDataLength";
    private static final String SUFFIX_FILE_COUNT = "globalFileCount";
    private static final String SUFFIX_LIVE_DATA_LENGTH = "liveDataLength";
    private static final String DESCRIPTION_TOTAL_DATA_LENGTH = "Displays total data length. This is the accumulated size of all storage data files.";
    private static final String DESCRIPTION_FILE_COUNT = "Displays the number of storage files.";
    private static final String DESCRIPTION_LIVE_DATA_LENGTH = "Displays live data length. This is the 'real' size of the stored data.";
    private static final String DOT = ".";
    private final Map<String, StorageManager> storageManagerMap = new ConcurrentHashMap<String, StorageManager>();

    public MicroStreamMetricsBinder(BeanContext beanContext) {
        for (BeanDefinition definition : beanContext.getBeanDefinitions(StorageManager.class)) {
            if (!(definition.getDeclaredQualifier() instanceof Named)) continue;
            StorageManager storageManager = (StorageManager)beanContext.getBean(definition);
            this.storageManagerMap.putIfAbsent(((Named)definition.getDeclaredQualifier()).getName(), storageManager);
        }
    }

    public void bindTo(@NonNull MeterRegistry registry) {
        this.storageManagerMap.forEach((key, value) -> this.bindStorageManagerToRegistry((String)key, (StorageManager)value, registry));
    }

    private void bindStorageManagerToRegistry(@NonNull String name, @NonNull StorageManager manager, @NonNull MeterRegistry registry) {
        this.gauge(registry, name, SUFFIX_TOTAL_DATA_LENGTH, DESCRIPTION_TOTAL_DATA_LENGTH, () -> manager.createStorageStatistics().totalDataLength(), "bytes");
        this.gauge(registry, name, SUFFIX_FILE_COUNT, DESCRIPTION_FILE_COUNT, () -> manager.createStorageStatistics().fileCount(), "files");
        this.gauge(registry, name, SUFFIX_LIVE_DATA_LENGTH, DESCRIPTION_LIVE_DATA_LENGTH, () -> manager.createStorageStatistics().liveDataLength(), "bytes");
    }

    private void gauge(@NonNull MeterRegistry registry, @NonNull String managerName, @NonNull String suffix, @NonNull String description, @NonNull Supplier<Number> value, @NonNull String units) {
        Gauge.builder((String)String.join((CharSequence)DOT, MICROSTREAM_METRIC_PREFIX, managerName, suffix), value).description(description).baseUnit(units).register(registry);
    }
}

