/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.microstream.conf;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.microstream.conf.EmbeddedStorageConfigurationProvider;
import jakarta.inject.Singleton;
import one.microstream.storage.embedded.types.EmbeddedStorageFoundation;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;
import one.microstream.storage.types.StorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class StorageManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StorageManagerFactory.class);
    private final BeanContext beanContext;

    public StorageManagerFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @EachBean(value=EmbeddedStorageFoundation.class)
    @Bean(preDestroy="shutdown")
    @Singleton
    public StorageManager createStorageManager(EmbeddedStorageFoundation<?> foundation, @Parameter String name) {
        EmbeddedStorageManager storageManager = foundation.createEmbeddedStorageManager().start();
        if (storageManager.root() == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No data found");
            }
            if (!this.beanContext.containsBean(EmbeddedStorageConfigurationProvider.class, Qualifiers.byName((String)name))) {
                throw new DisabledBeanException("Please, define a bean of type " + EmbeddedStorageConfigurationProvider.class.getSimpleName() + " by name qualifier: " + name);
            }
            EmbeddedStorageConfigurationProvider configuration = (EmbeddedStorageConfigurationProvider)this.beanContext.getBean(EmbeddedStorageConfigurationProvider.class, Qualifiers.byName((String)name));
            if (configuration.getRootClass() != null) {
                storageManager.setRoot(InstantiationUtils.instantiate(configuration.getRootClass()));
            }
            storageManager.storeRoot();
        }
        return storageManager;
    }
}

