/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.microstream.health;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import io.micronaut.health.HealthStatus;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.micronaut.microstream.health.MicroStreamHealth;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import one.microstream.storage.types.StorageManager;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@Requirements(value={@Requires(classes={HealthIndicator.class}), @Requires(property="endpoints.health.microstream.enabled", value="true", defaultValue="true")})
public class MicroStreamHealthIndicator
implements HealthIndicator {
    public static final String MICROSTREAM_PREFIX = "microstream";
    private static final String DOT = ".";
    private final Map<String, StorageManager> storageManagerMap = new ConcurrentHashMap<String, StorageManager>();

    public MicroStreamHealthIndicator(BeanContext beanContext) {
        for (BeanDefinition definition : beanContext.getBeanDefinitions(StorageManager.class)) {
            if (!(definition.getDeclaredQualifier() instanceof Named)) continue;
            String name = ((Named)definition.getDeclaredQualifier()).getName();
            StorageManager storageManager = (StorageManager)beanContext.getBean(definition);
            this.storageManagerMap.putIfAbsent(name, storageManager);
        }
    }

    public Publisher<HealthResult> getResult() {
        return Flux.fromIterable(this.storageManagerMap.entrySet()).map(namedBean -> {
            StorageManager manager = (StorageManager)namedBean.getValue();
            return HealthResult.builder((String)String.join((CharSequence)DOT, MICROSTREAM_PREFIX, (CharSequence)namedBean.getKey()), (HealthStatus)(((StorageManager)namedBean.getValue()).isRunning() ? HealthStatus.UP : HealthStatus.DOWN)).details((Object)MicroStreamHealthIndicator.healthOfManager(manager)).build();
        });
    }

    @NonNull
    private static MicroStreamHealth healthOfManager(@NonNull StorageManager manager) {
        return new MicroStreamHealth(manager.isStartingUp(), manager.isRunning(), manager.isActive(), manager.isAcceptingTasks(), manager.isShuttingDown(), manager.isShutdown());
    }
}

