/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.microstream.interceptors;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.microstream.annotations.Store;
import io.micronaut.microstream.annotations.StoringStrategy;
import io.micronaut.microstream.interceptors.StorageInterceptorException;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import one.microstream.concurrency.XThreads;
import one.microstream.persistence.types.PersistenceStoring;
import one.microstream.persistence.types.Storer;
import one.microstream.storage.types.StorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
@InterceptorBean(value={Store.class})
public class StoreInterceptor
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreInterceptor.class);
    private static final String MULTIPLE_MANAGERS_WITH_NO_QUALIFIER_MESSAGE = "Multiple storage managers found, but no name was specified.";
    private static final String DEFAULT_SINGLE_MANAGER_KEY = "__default__";
    private static final String PARAMETERS = "parameters";
    private static final String RESULT = "result";
    private static final String STRATEGY = "strategy";
    private static final String ROOT = "root";
    private final ConcurrentHashMap<String, StorageManager> managerLookup = new ConcurrentHashMap();
    private final BeanContext beanContext;

    public StoreInterceptor(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context);
        switch (interceptedMethod.resultType()) {
            case PUBLISHER: 
            case COMPLETION_STAGE: {
                return context.proceed();
            }
            case SYNCHRONOUS: {
                AnnotationValue storeAnnotationValue = context.getAnnotation(Store.class);
                if (storeAnnotationValue == null) {
                    return context.proceed();
                }
                StorageManager manager = this.lookupManager((AnnotationValue<Store>)storeAnnotationValue);
                return XThreads.executeSynchronized(() -> {
                    Object result = context.proceed();
                    this.store(manager, context, (AnnotationValue<Store>)storeAnnotationValue, result);
                    return result;
                });
            }
        }
        return interceptedMethod.unsupported();
    }

    private void store(@NonNull StorageManager storageManager, @NonNull MethodInvocationContext<Object, Object> context, @NonNull AnnotationValue<Store> storeAnnotationValue, @Nullable Object result) {
        if (storeAnnotationValue.booleanValue(ROOT).orElse(false).booleanValue()) {
            StoreInterceptor.storeRoot(storeAnnotationValue, storageManager);
        } else {
            List<Object> objects = StoreInterceptor.targetParametersValues(context, storeAnnotationValue);
            if (result != null && storeAnnotationValue.booleanValue(RESULT).orElse(false).booleanValue()) {
                objects.add(result);
            }
            if (CollectionUtils.isNotEmpty(objects)) {
                StoreInterceptor.store(storeAnnotationValue, storageManager, objects);
            }
        }
    }

    private static void store(@NonNull AnnotationValue<Store> storeAnnotationValue, @NonNull StorageManager storageManager, @NonNull Consumer<Storer> eagerConsumer, @NonNull Runnable lazyRunnable) {
        StoringStrategy storingStrategy = storeAnnotationValue.enumValue(STRATEGY, StoringStrategy.class).orElse(StoringStrategy.LAZY);
        StoreInterceptor.store(storingStrategy, storageManager, eagerConsumer, lazyRunnable);
    }

    private static void store(@NonNull StoringStrategy storingStrategy, @NonNull StorageManager storageManager, @NonNull Consumer<Storer> eagerConsumer, @NonNull Runnable lazyRunnable) {
        switch (storingStrategy) {
            case EAGER: {
                Storer storer = storageManager.createEagerStorer();
                eagerConsumer.accept(storer);
                storer.commit();
                break;
            }
            default: {
                lazyRunnable.run();
            }
        }
    }

    private static void storeRoot(@NonNull AnnotationValue<Store> storeAnnotationValue, @NonNull StorageManager storageManager) {
        Object root = storageManager.root();
        StoreInterceptor.store(storeAnnotationValue, storageManager, (Storer storer) -> StoreInterceptor.storeRootObject(root, (PersistenceStoring)storer), () -> StoreInterceptor.storeRootObject(root, (PersistenceStoring)storageManager));
    }

    private static void store(@NonNull AnnotationValue<Store> storeAnnotationValue, @NonNull StorageManager storageManager, @NonNull List<Object> instances) {
        StoreInterceptor.store(storeAnnotationValue, storageManager, (Storer storer) -> StoreInterceptor.storeAll((PersistenceStoring)storer, instances), () -> StoreInterceptor.storeAll((PersistenceStoring)storageManager, instances));
    }

    private static void storeAll(@NonNull PersistenceStoring storing, @NonNull List<Object> instances) {
        for (Object instance : instances) {
            storing.store(instance);
        }
    }

    @NonNull
    private StorageManager lookupManager(@NonNull AnnotationValue<Store> storeAnnotationValue) {
        String name = Optional.of(storeAnnotationValue).flatMap(a -> a.stringValue("name")).orElse(null);
        return this.lookupManager(name);
    }

    @NonNull
    private StorageManager lookupManager(@Nullable String name) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return this.managerLookup.computeIfAbsent(name, this::getManagerForName);
        }
        return this.managerLookup.computeIfAbsent(DEFAULT_SINGLE_MANAGER_KEY, ignored -> this.getSingleManager());
    }

    @NonNull
    private StorageManager getSingleManager() {
        Collection beansOfType = this.beanContext.getBeanDefinitions(StorageManager.class);
        if (beansOfType.size() != 1) {
            throw new IllegalStateException(MULTIPLE_MANAGERS_WITH_NO_QUALIFIER_MESSAGE);
        }
        return (StorageManager)this.beanContext.getBean((BeanDefinition)beansOfType.iterator().next());
    }

    @NonNull
    private StorageManager getManagerForName(@NonNull String name) {
        if (this.beanContext.containsBean(StorageManager.class, Qualifiers.byName((String)name))) {
            return (StorageManager)this.beanContext.getBean(StorageManager.class, Qualifiers.byName((String)name));
        }
        throw new StorageInterceptorException("No storage manager found for @" + Store.class.getSimpleName() + "(name = \"" + name + "\").");
    }

    @NonNull
    private static Map<String, MutableArgumentValue<?>> targetParameters(@NonNull MethodInvocationContext<Object, Object> context, @NonNull AnnotationValue<Store> storeAnnotationValue) {
        Map parameters = context.getParameters();
        HashMap targetParameters = new HashMap();
        String[] storeAnnotationValueParameters = storeAnnotationValue.stringValues(PARAMETERS);
        for (Map.Entry entry : parameters.entrySet()) {
            if (!Arrays.stream(storeAnnotationValueParameters).anyMatch(it -> it.equalsIgnoreCase((String)entry.getKey()))) continue;
            targetParameters.put((String)entry.getKey(), (MutableArgumentValue)entry.getValue());
        }
        return targetParameters;
    }

    @NonNull
    private static List<Object> targetParametersValues(@NonNull MethodInvocationContext<Object, Object> context, @NonNull AnnotationValue<Store> storeAnnotationValue) {
        Map<String, MutableArgumentValue<?>> params = StoreInterceptor.targetParameters(context, storeAnnotationValue);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<String, MutableArgumentValue<?>> entry : params.entrySet()) {
            MutableArgumentValue<?> argumentValue = entry.getValue();
            Object obj = argumentValue.getValue();
            if (obj == null) continue;
            result.add(obj);
        }
        return result;
    }

    private static void storeRootObject(Object root, PersistenceStoring storing) {
        long storeId = storing.store(root);
        if (LOG.isWarnEnabled()) {
            LOG.warn("Storing the root object may result in performance issues {}", (Object)storeId);
        }
    }
}

