/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.reactive.health;

import com.mongodb.BasicDBObject;
import com.mongodb.reactivestreams.client.MongoClient;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.aggregator.HealthAggregator;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.reactivex.Flowable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

@Singleton
@Requires(beans={MongoClient.class})
public class MongoHealthIndicator
implements HealthIndicator {
    private static final String HEALTH_INDICATOR_NAME = "mongodb";
    private final BeanContext beanContext;
    private final HealthAggregator<?> healthAggregator;
    private final MongoClient[] mongoClients;

    public MongoHealthIndicator(BeanContext beanContext, HealthAggregator<?> healthAggregator, MongoClient ... mongoClients) {
        this.beanContext = beanContext;
        this.healthAggregator = healthAggregator;
        this.mongoClients = mongoClients;
    }

    public Publisher<HealthResult> getResult() {
        List<BeanRegistration<MongoClient>> registrations = this.getRegisteredConnections();
        Flowable healthResults = Flowable.fromIterable(registrations).flatMap(this::checkRegisteredMongoClient).onErrorReturn(throwable -> this.buildStatusDown((Throwable)throwable, HEALTH_INDICATOR_NAME));
        return this.healthAggregator.aggregate(HEALTH_INDICATOR_NAME, (Publisher)healthResults);
    }

    private List<BeanRegistration<MongoClient>> getRegisteredConnections() {
        return Arrays.stream(this.mongoClients).map(arg_0 -> ((BeanContext)this.beanContext).findBeanRegistration(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Publisher<HealthResult> checkRegisteredMongoClient(BeanRegistration<MongoClient> registration) {
        MongoClient mongoClient = (MongoClient)registration.getBean();
        String databaseName = "mongodb (" + registration.getIdentifier().getName() + ")";
        Flowable databasePings = Flowable.fromPublisher(this.pingMongo(mongoClient)).map(this::getVersionDetails).timeout(10L, TimeUnit.SECONDS).retry(3L);
        return databasePings.map(detail -> this.buildStatusUp(databaseName, (Map<String, String>)detail)).onErrorReturn(throwable -> this.buildStatusDown((Throwable)throwable, databaseName));
    }

    private Publisher<Document> pingMongo(MongoClient mongoClient) {
        return mongoClient.getDatabase("admin").runCommand((Bson)new BasicDBObject("buildinfo", (Object)"1"));
    }

    private Map<String, String> getVersionDetails(Document document) {
        String version = (String)document.get((Object)"version", String.class);
        if (version == null) {
            throw new IllegalStateException("Mongo version not found");
        }
        return Collections.singletonMap("version", version);
    }

    private HealthResult buildStatusUp(String name, Map<String, String> details) {
        HealthResult.Builder builder = HealthResult.builder((String)name);
        builder.status(HealthStatus.UP);
        builder.details(details);
        return builder.build();
    }

    private HealthResult buildStatusDown(Throwable throwable, String name) {
        HealthResult.Builder builder = HealthResult.builder((String)name);
        builder.status(HealthStatus.DOWN);
        builder.exception(throwable);
        return builder.build();
    }
}

