/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.mqtt.v3.client;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.mqtt.v3.config.MqttClientConfigurationProperties;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.ScheduledExecutorPingSender;
import org.eclipse.paho.client.mqttv3.internal.HighResolutionTimer;

@Factory
public final class MqttClientFactory {
    @Singleton
    @Bean(preDestroy="disconnect")
    MqttAsyncClient mqttClient(MqttClientConfigurationProperties configuration, @Nullable MqttClientPersistence clientPersistence, @Nullable HighResolutionTimer highResolutionTimer, @Named(value="consumer") ExecutorService executorService) throws MqttException {
        ScheduledExecutorService consumerExecutor = (ScheduledExecutorService)executorService;
        MqttAsyncClient client = new MqttAsyncClient(configuration.getServerUri(), configuration.getClientId(), clientPersistence, (MqttPingSender)new ScheduledExecutorPingSender(consumerExecutor), consumerExecutor, highResolutionTimer);
        configuration.getManualAcks().ifPresent(arg_0 -> ((MqttAsyncClient)client).setManualAcks(arg_0));
        client.connect(configuration.getConnectOptions()).waitForCompletion(configuration.getConnectionTimeout().toMillis());
        return client;
    }
}

