/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.mqtt.v3.client.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Singleton;
import java.util.Collections;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(property="endpoints.health.mqtt.client.enabled", value="true"), @Requires(beans={HealthEndpoint.class})})
@Singleton
public class MqttHealthIndicator
implements HealthIndicator {
    public static final String NAME = "mqtt-client";
    private MqttAsyncClient client;

    public MqttHealthIndicator(MqttAsyncClient client) {
        this.client = client;
    }

    public Publisher<HealthResult> getResult() {
        HealthStatus status = this.client.isConnected() ? HealthStatus.UP : HealthStatus.DOWN;
        HealthResult.Builder builder = HealthResult.builder((String)NAME, (HealthStatus)status).details(Collections.singletonMap("clientId", this.client.getClientId()));
        return Publishers.just((Object)builder.build());
    }
}

