/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.mqtt.v3.intercept;

import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.mqtt.annotation.v3.MqttPublisher;
import io.micronaut.mqtt.bind.MqttBinderRegistry;
import io.micronaut.mqtt.bind.MqttBindingContext;
import io.micronaut.mqtt.exception.MqttClientException;
import io.micronaut.mqtt.intercept.AbstractMqttIntroductionAdvice;
import io.micronaut.mqtt.v3.bind.MqttV3BindingContext;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

@Singleton
@InterceptorBean(value={MqttPublisher.class})
public class MqttIntroductionAdvice
extends AbstractMqttIntroductionAdvice<IMqttActionListener, MqttMessage> {
    private final MqttAsyncClient mqttAsyncClient;

    public MqttIntroductionAdvice(MqttAsyncClient mqttAsyncClient, MqttBinderRegistry binderRegistry) {
        super(binderRegistry);
        this.mqttAsyncClient = mqttAsyncClient;
    }

    public MqttBindingContext<MqttMessage> createBindingContext(MethodInvocationContext<Object, Object> context) {
        return new MqttV3BindingContext(this.mqttAsyncClient, new MqttMessage());
    }

    public Object publish(String topic, MqttMessage message, IMqttActionListener listener) {
        try {
            return this.mqttAsyncClient.publish(topic, message, null, listener);
        }
        catch (MqttException e) {
            throw new MqttClientException("Failed to publish the message", (Throwable)e);
        }
    }

    public IMqttActionListener createListener(final Runnable onSuccess, final Consumer<Throwable> onError) {
        return new IMqttActionListener(){

            public void onSuccess(IMqttToken asyncActionToken) {
                onSuccess.run();
            }

            public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                onError.accept(exception);
            }
        };
    }

    public Class<? extends Annotation> getRequiredAnnotation() {
        return MqttPublisher.class;
    }
}

