/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.mqtt.v5.intercept;

import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.util.StringUtils;
import io.micronaut.mqtt.annotation.v5.MqttProperty;
import io.micronaut.mqtt.annotation.v5.MqttPublisher;
import io.micronaut.mqtt.bind.MqttBinderRegistry;
import io.micronaut.mqtt.bind.MqttBindingContext;
import io.micronaut.mqtt.exception.MqttClientException;
import io.micronaut.mqtt.intercept.AbstractMqttIntroductionAdvice;
import io.micronaut.mqtt.v5.bind.MqttV5BindingContext;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttActionListener;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.UserProperty;

@Singleton
@InterceptorBean(value={MqttPublisher.class})
public class MqttIntroductionAdvice
extends AbstractMqttIntroductionAdvice<MqttActionListener, MqttMessage> {
    private final MqttAsyncClient mqttAsyncClient;

    public MqttIntroductionAdvice(MqttAsyncClient mqttAsyncClient, MqttBinderRegistry binderRegistry) {
        super(binderRegistry);
        this.mqttAsyncClient = mqttAsyncClient;
    }

    public Object publish(String topic, MqttMessage message, MqttActionListener listener) {
        try {
            return this.mqttAsyncClient.publish(topic, message, null, listener);
        }
        catch (MqttException e) {
            throw new MqttClientException("Failed to publish the message", (Throwable)e);
        }
    }

    public MqttBindingContext<MqttMessage> createBindingContext(MethodInvocationContext<Object, Object> context) {
        MqttMessage message = new MqttMessage();
        List propertyAnnotations = context.getAnnotationValuesByType(MqttProperty.class);
        MqttProperties properties = new MqttProperties();
        propertyAnnotations.forEach(prop -> {
            String name = prop.get((CharSequence)"name", String.class).orElse(null);
            String value = prop.getValue(String.class).orElse(null);
            BeanIntrospection introspection = BeanIntrospection.getIntrospection(MqttProperties.class);
            if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)value)) {
                Optional property = introspection.getProperty(name);
                if (property.isPresent()) {
                    ((BeanProperty)property.get()).convertAndSet((Object)properties, (Object)value);
                } else {
                    properties.getUserProperties().add(new UserProperty(name, value));
                }
            }
        });
        message.setProperties(properties);
        return new MqttV5BindingContext(this.mqttAsyncClient, message);
    }

    public MqttActionListener createListener(final Runnable onSuccess, final Consumer<Throwable> onError) {
        return new MqttActionListener(){

            public void onSuccess(IMqttToken asyncActionToken) {
                onSuccess.run();
            }

            public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                onError.accept(exception);
            }
        };
    }

    public Class<? extends Annotation> getRequiredAnnotation() {
        return MqttPublisher.class;
    }
}

