/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.mqtt.v5.client;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.mqtt.v5.config.MqttClientConfigurationProperties;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttPingSender;
import org.eclipse.paho.mqttv5.client.TimerPingSender;
import org.eclipse.paho.mqttv5.common.MqttException;

@Factory
public final class MqttClientFactory {
    @Singleton
    @Bean(preDestroy="disconnect")
    MqttAsyncClient mqttClient(MqttClientConfigurationProperties configuration, @Nullable MqttClientPersistence clientPersistence, @Named(value="consumer") ExecutorService executorService) throws MqttException {
        ScheduledExecutorService consumerExecutor = (ScheduledExecutorService)executorService;
        MqttAsyncClient client = new MqttAsyncClient(configuration.getServerUri(), configuration.getClientId(), clientPersistence, (MqttPingSender)new TimerPingSender(consumerExecutor), consumerExecutor);
        client.connect(configuration.getConnectOptions()).waitForCompletion(configuration.getConnectionTimeout().toMillis());
        return client;
    }
}

