/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.mqtt.v5.bind;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.mqtt.annotation.v5.MqttProperty;
import io.micronaut.mqtt.bind.AnnotatedMqttBinder;
import io.micronaut.mqtt.v5.bind.MqttV5BindingContext;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.UserProperty;

@Introspected(classes={MqttProperties.class})
@Singleton
public class MqttPropertyBinder
implements AnnotatedMqttBinder<MqttV5BindingContext, MqttProperty> {
    private final ConversionService conversionService;
    private final BeanIntrospection<MqttProperties> introspection;

    public MqttPropertyBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
        this.introspection = BeanIntrospection.getIntrospection(MqttProperties.class);
    }

    public Class<MqttProperty> getAnnotationType() {
        return MqttProperty.class;
    }

    public void bindTo(MqttV5BindingContext context, Object value, Argument<Object> argument) {
        String name = this.getParameterName(argument);
        Optional property = this.introspection.getProperty(name);
        if (property.isPresent()) {
            ((BeanProperty)property.get()).convertAndSet((Object)context.getProperties(), value);
        } else {
            List userProperties = context.getProperties().getUserProperties();
            userProperties.removeIf(up -> up.getKey().equals(name));
            this.conversionService.convert(value, Argument.STRING).map(val -> new UserProperty(name, val)).ifPresent(userProperties::add);
        }
    }

    public Optional<Object> bindFrom(MqttV5BindingContext context, ArgumentConversionContext<Object> conversionContext) {
        String name = this.getParameterName(conversionContext.getArgument());
        Optional property = this.introspection.getProperty(name);
        if (property.isPresent()) {
            return ((BeanProperty)property.get()).get((Object)context.getProperties(), conversionContext);
        }
        List userProperties = context.getProperties().getUserProperties();
        for (UserProperty up : userProperties) {
            if (!up.getKey().equals(name)) continue;
            return this.conversionService.convert((Object)up.getValue(), conversionContext);
        }
        return Optional.empty();
    }

    private String getParameterName(Argument<?> argument) {
        return argument.findAnnotation(MqttProperty.class).flatMap(AnnotationValue::stringValue).orElse(argument.getName());
    }
}

