/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.mqtt.v5.bind;

import io.micronaut.core.annotation.Internal;
import io.micronaut.mqtt.bind.MqttBindingContext;
import io.micronaut.mqtt.exception.MqttSubscriberException;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class MqttV5BindingContext
implements MqttBindingContext<MqttMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(MqttV5BindingContext.class);
    private final MqttAsyncClient client;
    private final MqttMessage message;
    private String topic;

    public MqttV5BindingContext(MqttAsyncClient client, MqttMessage message) {
        this.client = client;
        this.message = message;
    }

    public byte[] getPayload() {
        return this.message.getPayload();
    }

    public void setPayload(byte[] payload) {
        this.message.setPayload(payload);
    }

    public boolean isRetained() {
        return this.message.isRetained();
    }

    public void setRetained(boolean retained) {
        this.message.setRetained(retained);
    }

    public int getQos() {
        return this.message.getQos();
    }

    public void setQos(int qos) {
        this.message.setQos(qos);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public MqttProperties getProperties() {
        return this.message.getProperties();
    }

    public void setProperties(MqttProperties properties) {
        this.message.setProperties(properties);
    }

    public int getId() {
        return this.message.getId();
    }

    public void acknowlege() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Acknowledging message id {} with qos {}", (Object)this.message.getId(), (Object)this.message.getQos());
            }
            this.client.messageArrivedComplete(this.message.getId(), this.message.getQos());
        }
        catch (MqttException e) {
            throw new MqttSubscriberException("Failed to acknowledge the message", (Throwable)e);
        }
    }

    public MqttMessage getNativeMessage() {
        return this.message;
    }
}

