/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.mqtt.v5.config;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.mqtt.config.MqttSSLConfiguration;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;

@ConfigurationProperties(value="mqtt.client")
public class MqttClientConfigurationProperties
implements MqttSSLConfiguration {
    private String serverUri;
    private String clientId;
    private Duration connectionTimeout = Duration.ofSeconds(3L);
    @ConfigurationBuilder(excludes={"socketFactory", "SSLProperties", "httpsHostnameVerificationEnabled", "SSLHostnameVerifier"})
    private final MqttConnectionOptions connectOptions = new MqttConnectionOptions();

    public MqttClientConfigurationProperties(WillMessage willMessage) {
        if (willMessage.getTopic() != null) {
            this.connectOptions.setWill(willMessage.getTopic(), new MqttMessage(willMessage.getPayload(), willMessage.getQos(), willMessage.isRetained(), willMessage.getProperties()));
        }
    }

    public MqttConnectionOptions getConnectOptions() {
        return this.connectOptions;
    }

    @NotNull
    public String getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public SocketFactory getSocketFactory() {
        return this.connectOptions.getSocketFactory();
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.connectOptions.setSocketFactory(socketFactory);
    }

    public Properties getSSLProperties() {
        return this.connectOptions.getSSLProperties();
    }

    public void setSSLProperties(Properties props) {
        this.connectOptions.setSSLProperties(props);
    }

    public boolean isHttpsHostnameVerificationEnabled() {
        return this.connectOptions.isHttpsHostnameVerificationEnabled();
    }

    public void setHttpsHostnameVerificationEnabled(boolean httpsHostnameVerificationEnabled) {
        this.connectOptions.setHttpsHostnameVerificationEnabled(httpsHostnameVerificationEnabled);
    }

    public HostnameVerifier getSSLHostnameVerifier() {
        return this.connectOptions.getSSLHostnameVerifier();
    }

    public void setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.connectOptions.setSSLHostnameVerifier(hostnameVerifier);
    }

    @ConfigurationProperties(value="will-message")
    static class WillMessage {
        private String topic;
        private byte[] payload;
        private int qos;
        private boolean retained;
        @ConfigurationBuilder(value="properties")
        private MqttProperties properties = new MqttProperties();

        WillMessage() {
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public byte[] getPayload() {
            return this.payload;
        }

        public void setPayload(byte[] payload) {
            this.payload = payload;
        }

        public int getQos() {
            return this.qos;
        }

        public void setQos(int qos) {
            this.qos = qos;
        }

        public boolean isRetained() {
            return this.retained;
        }

        public void setRetained(boolean retained) {
            this.retained = retained;
        }

        public MqttProperties getProperties() {
            return this.properties;
        }

        public void setProperties(MqttProperties properties) {
            this.properties = properties;
        }
    }
}

