/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.CookieTenantResolverConfiguration;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import java.io.Serializable;
import java.util.Optional;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;

@Singleton
@Requirements(value={@Requires(beans={CookieTenantResolverConfiguration.class}), @Requires(property="micronaut.multitenancy.tenantresolver.cookie.enabled", value="true", defaultValue="false")})
public class CookieTenantResolver
implements TenantResolver,
HttpRequestTenantResolver {
    protected String cookiename = "tenantId";

    public CookieTenantResolver(CookieTenantResolverConfiguration configuration) {
        if (configuration != null) {
            this.cookiename = configuration.getCookiename();
        }
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier() throws TenantNotFoundException {
        Optional current = ServerRequestContext.currentRequest();
        return current.map(this::resolveTenantIdentifierAtRequest).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved outside a web request"));
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier(@NotNull @NonNull HttpRequest<?> request) throws TenantNotFoundException {
        Optional optionalTenantId;
        if (request.getCookies() != null && (optionalTenantId = request.getCookies().findCookie((CharSequence)this.cookiename)).isPresent()) {
            return ((Cookie)optionalTenantId.get()).getValue();
        }
        throw new TenantNotFoundException("Tenant could not be resolved from the Cookie: " + this.cookiename);
    }

    @Deprecated
    protected Serializable resolveTenantIdentifierAtRequest(HttpRequest<Object> request) throws TenantNotFoundException {
        return this.resolveTenantIdentifier(request);
    }
}

