/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import java.io.Serializable;
import java.security.Principal;
import java.util.Optional;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;

@Singleton
@Requires(property="micronaut.multitenancy.tenantresolver.principal.enabled", value="true", defaultValue="false")
public class PrincipalTenantResolver
implements TenantResolver,
HttpRequestTenantResolver {
    @Override
    @NonNull
    public Serializable resolveTenantIdentifier() {
        Optional current = ServerRequestContext.currentRequest();
        return current.map(this::resolveTenantIdentifierAtRequest).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved outside a web request"));
    }

    @Deprecated
    @NonNull
    protected Serializable resolveTenantIdentifierAtRequest(HttpRequest<Object> request) throws TenantNotFoundException {
        return this.resolveTenantIdentifier(request);
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier(@NotNull @NonNull HttpRequest<?> request) throws TenantNotFoundException {
        return (Serializable)((Object)request.getUserPrincipal().map(Principal::getName).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved because " + HttpAttributes.PRINCIPAL + " attribute was not found")));
    }
}

