/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import java.io.Serializable;
import java.util.Optional;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;

@Singleton
@Requires(property="micronaut.multitenancy.tenantresolver.subdomain.enabled", value="true", defaultValue="false")
public class SubdomainTenantResolver
implements TenantResolver,
HttpRequestTenantResolver {
    @Override
    @NonNull
    public Serializable resolveTenantIdentifier() {
        Optional current = ServerRequestContext.currentRequest();
        return current.map(this::resolveTenantIdentifierAtRequest).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved outside a web request"));
    }

    @Deprecated
    protected Serializable resolveTenantIdentifierAtRequest(HttpRequest<Object> request) throws TenantNotFoundException {
        return this.resolveTenantIdentifier(request);
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier(@NotNull @NonNull HttpRequest<?> request) throws TenantNotFoundException {
        if (request.getHeaders() != null) {
            String host = (String)request.getHeaders().get((CharSequence)"Host");
            if (host != null) {
                if (host.contains("/")) {
                    host = host.substring(host.indexOf("/") + 2);
                }
                if (host.contains(".")) {
                    return host.substring(0, host.indexOf("."));
                }
            }
            return "DEFAULT";
        }
        return "DEFAULT";
    }
}

