/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.SystemPropertyTenantResolverConfiguration;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import java.io.Serializable;
import javax.inject.Singleton;

@Singleton
@Requirements(value={@Requires(beans={SystemPropertyTenantResolverConfiguration.class}), @Requires(property="micronaut.multitenancy.tenantresolver.systemproperty.enabled", value="true", defaultValue="false")})
public class SystemPropertyTenantResolver
implements TenantResolver {
    private SystemPropertyTenantResolverConfiguration systemPropertyTenantResolverConfiguration;

    public SystemPropertyTenantResolver(SystemPropertyTenantResolverConfiguration systemPropertyTenantResolverConfiguration) {
        this.systemPropertyTenantResolverConfiguration = systemPropertyTenantResolverConfiguration;
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier() throws TenantNotFoundException {
        String value = System.getProperty(this.systemPropertyTenantResolverConfiguration.getSystemPropertyName());
        if (value == null) {
            throw new TenantNotFoundException("System property (" + this.systemPropertyTenantResolverConfiguration.getSystemPropertyName() + ") not found");
        }
        return value;
    }
}

