/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.SessionTenantResolverConfiguration;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import io.micronaut.session.Session;
import io.micronaut.session.http.HttpSessionFilter;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.util.Optional;
import javax.validation.constraints.NotNull;

@Requirements(value={@Requires(classes={Session.class, HttpSessionFilter.class}), @Requires(beans={SessionTenantResolverConfiguration.class}), @Requires(property="micronaut.multitenancy.tenantresolver.session.enabled", value="true", defaultValue="false")})
@Singleton
public class SessionTenantResolver
implements TenantResolver,
HttpRequestTenantResolver {
    private final String attribute;

    public SessionTenantResolver(SessionTenantResolverConfiguration configuration) {
        this.attribute = configuration != null ? configuration.getAttribute() : "tenantId";
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier() throws TenantNotFoundException {
        Optional current = ServerRequestContext.currentRequest();
        return current.map(this::resolveTenantIdentifier).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved outside a web request"));
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier(@NonNull @NotNull HttpRequest<?> request) throws TenantNotFoundException {
        if (this.attribute == null) {
            throw new TenantNotFoundException("Tenant could not be resolved from HTTP Session, because session attribute name is not set");
        }
        Optional opt = request.getAttributes().get(HttpSessionFilter.SESSION_ATTRIBUTE, Session.class);
        if (!opt.isPresent()) {
            throw new TenantNotFoundException("Tenant could not be resolved from HTTP Session, if session not present");
        }
        Session session = (Session)opt.get();
        Optional tenantId = session.get((CharSequence)this.attribute);
        if (!tenantId.isPresent()) {
            throw new TenantNotFoundException("Tenant could not be resolved from HTTP Session, if session attribute (" + this.attribute + ") not present");
        }
        if (!(tenantId.get() instanceof Serializable)) {
            throw new TenantNotFoundException("Tenant was resolved from HTTP Session, but it is not serializable");
        }
        return (Serializable)tenantId.get();
    }
}

