/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.propagation;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.util.OutgoingHttpRequestProcessor;
import io.micronaut.http.util.OutgointRequestProcessorMatcher;
import io.micronaut.multitenancy.exceptions.TenantException;
import io.micronaut.multitenancy.propagation.TenantPropagationConfiguration;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import io.micronaut.multitenancy.writer.TenantWriter;
import java.io.Serializable;
import org.reactivestreams.Publisher;

@Filter(value={"${micronaut.multitenancy.propagation.path:/**}"})
@Requirements(value={@Requires(beans={TenantWriter.class, TenantResolver.class, TenantPropagationConfiguration.class, OutgoingHttpRequestProcessor.class}), @Requires(property="micronaut.multitenancy.propagation.enabled")})
public class TenantPropagationHttpClientFilter
implements HttpClientFilter {
    protected final TenantPropagationConfiguration tenantPropagationConfiguration;
    protected final TenantWriter tokenWriter;
    protected final TenantResolver tenantResolver;
    protected final OutgoingHttpRequestProcessor outgoingHttpRequestProcessor;

    public TenantPropagationHttpClientFilter(TenantResolver tenantResolver, TenantWriter tokenWriter, TenantPropagationConfiguration tenantPropagationConfiguration, OutgoingHttpRequestProcessor outgoingHttpRequestProcessor) {
        this.tenantResolver = tenantResolver;
        this.tokenWriter = tokenWriter;
        this.tenantPropagationConfiguration = tenantPropagationConfiguration;
        this.outgoingHttpRequestProcessor = outgoingHttpRequestProcessor;
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> targetRequest, ClientFilterChain chain) {
        if (!this.outgoingHttpRequestProcessor.shouldProcessRequest((OutgointRequestProcessorMatcher)this.tenantPropagationConfiguration, targetRequest)) {
            return chain.proceed(targetRequest);
        }
        try {
            Serializable tenantId = this.tenantResolver.resolveTenantIdentifier();
            this.tokenWriter.writeTenant(targetRequest, tenantId);
            return chain.proceed(targetRequest);
        }
        catch (TenantException e) {
            return chain.proceed(targetRequest);
        }
    }
}

