/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.writer;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.multitenancy.writer.CookieTenantWriterConfiguration;
import io.micronaut.multitenancy.writer.TenantWriter;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.time.temporal.TemporalAmount;

@Singleton
@Requirements(value={@Requires(property="micronaut.multitenancy.tenantwriter.cookie.enabled"), @Requires(beans={CookieTenantWriterConfiguration.class})})
public class CookieTenantWriter
implements TenantWriter {
    protected final CookieTenantWriterConfiguration cookieTenantWriterConfiguration;

    public CookieTenantWriter(CookieTenantWriterConfiguration cookieTenantWriterConfiguration) {
        this.cookieTenantWriterConfiguration = cookieTenantWriterConfiguration;
    }

    @Override
    public void writeTenant(MutableHttpRequest<?> request, Serializable tenant) {
        if (tenant instanceof String) {
            Cookie cookie = Cookie.of((String)this.cookieTenantWriterConfiguration.getCookiename(), (String)((String)((Object)tenant)));
            cookie.configure((CookieConfiguration)this.cookieTenantWriterConfiguration, request.isSecure());
            if (this.cookieTenantWriterConfiguration.getCookieMaxAge().isPresent()) {
                cookie.maxAge((TemporalAmount)this.cookieTenantWriterConfiguration.getCookieMaxAge().get());
            } else {
                cookie.maxAge(Integer.MAX_VALUE);
            }
            request.cookie(cookie);
        }
    }
}

