/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.HttpHeaderTenantResolverConfiguration;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import jakarta.inject.Singleton;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;

@Singleton
@Requirements(value={@Requires(beans={HttpHeaderTenantResolverConfiguration.class}), @Requires(property="micronaut.multitenancy.tenantresolver.httpheader.enabled", value="true", defaultValue="false")})
public class HttpHeaderTenantResolver
implements TenantResolver,
HttpRequestTenantResolver {
    protected String headerName = "tenantId";

    public HttpHeaderTenantResolver(HttpHeaderTenantResolverConfiguration configuration) {
        if (configuration != null) {
            this.headerName = configuration.getHeaderName();
        }
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier() throws TenantNotFoundException {
        Optional current = ServerRequestContext.currentRequest();
        return current.map(this::resolveTenantIdentifier).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved outside a web request"));
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier(@NonNull @NotNull HttpRequest<?> request) throws TenantNotFoundException {
        String tenantId = (String)request.getHeaders().get((CharSequence)this.headerName);
        if (tenantId == null) {
            throw new TenantNotFoundException("Tenant could not be resolved. Header " + this.headerName + " value is null");
        }
        return tenantId;
    }
}

