/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

@Singleton
@Requires(property="micronaut.multitenancy.tenantresolver.subdomain.enabled", value="true", defaultValue="false")
public class SubdomainTenantResolver
implements TenantResolver,
HttpRequestTenantResolver {
    @Override
    @NonNull
    public Serializable resolveTenantIdentifier() {
        Optional current = ServerRequestContext.currentRequest();
        return current.map(this::resolveTenantIdentifier).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved outside a web request"));
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier(@NonNull HttpRequest<?> request) throws TenantNotFoundException {
        if (Objects.requireNonNull(request, "request must not be null").getHeaders() != null) {
            String host = (String)request.getHeaders().get((CharSequence)"Host");
            if (host != null) {
                if (host.contains("/")) {
                    host = host.substring(host.indexOf("/") + 2);
                }
                if (host.contains(".")) {
                    return host.substring(0, host.indexOf("."));
                }
            }
            return "DEFAULT";
        }
        return "DEFAULT";
    }
}

