/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.util.DefaultHttpHostResolver;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.multitenancy.tenantresolver.AbstractSubdomainTenantResolver;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;

@Singleton
@Secondary
@Requirements(value={@Requires(bean=HttpHostResolver.class), @Requires(property="micronaut.multitenancy.tenantresolver.subdomain.enabled", value="true", defaultValue="false")})
public class SubdomainTenantResolver
extends AbstractSubdomainTenantResolver {
    private static final char DOT = '.';

    @Inject
    public SubdomainTenantResolver(HttpHostResolver httpHostResolver) {
        super(httpHostResolver);
    }

    @Deprecated(since="5.0.3", forRemoval=true)
    public SubdomainTenantResolver() {
        this((HttpHostResolver)new DefaultHttpHostResolver(new HttpServerConfiguration(), null));
    }

    @Override
    @NonNull
    protected Serializable resolveSubdomain(@NonNull String host) {
        String domainWithoutSuffix;
        int index;
        if (host.chars().filter(ch -> ch == 46).count() > 1L && (index = (domainWithoutSuffix = host.substring(0, host.lastIndexOf(46))).lastIndexOf(46)) != -1) {
            return domainWithoutSuffix.substring(0, index);
        }
        return "DEFAULT";
    }
}

