/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import com.google.common.net.InternetDomainName;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.multitenancy.tenantresolver.AbstractSubdomainTenantResolver;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.util.stream.Collectors;

@Singleton
@Requirements(value={@Requires(bean=HttpHostResolver.class), @Requires(classes={InternetDomainName.class}), @Requires(property="micronaut.multitenancy.tenantresolver.subdomain.guava.enabled", value="true", defaultValue="true"), @Requires(property="micronaut.multitenancy.tenantresolver.subdomain.enabled", value="true", defaultValue="false")})
public class InternetDomainNameSubdomainTenantResolver
extends AbstractSubdomainTenantResolver {
    public InternetDomainNameSubdomainTenantResolver(HttpHostResolver httpHostResolver) {
        super(httpHostResolver);
    }

    @Override
    @NonNull
    protected Serializable resolveSubdomain(@NonNull String host) {
        InternetDomainName domain;
        int subdomainParts;
        if (InternetDomainName.isValid((String)host) && (subdomainParts = (domain = InternetDomainName.from((String)host)).parts().size() - this.getTopDomain(domain).parts().size()) > 0) {
            return (Serializable)((Object)domain.parts().stream().limit(subdomainParts).collect(Collectors.joining(".")));
        }
        return "DEFAULT";
    }

    private InternetDomainName getTopDomain(InternetDomainName domain) {
        return domain.isUnderPublicSuffix() ? domain.topPrivateDomain() : domain;
    }
}

