/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;

@Singleton
@Requires(property="micronaut.multitenancy.tenantresolver.principal.enabled", value="true", defaultValue="false")
public class PrincipalTenantResolver
implements TenantResolver,
HttpRequestTenantResolver {
    @Override
    @NonNull
    public String resolveTenantId() {
        Optional current = ServerRequestContext.currentRequest();
        return current.map(this::resolveTenantId).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved outside a web request"));
    }

    @Override
    @NonNull
    public String resolveTenantId(@NonNull HttpRequest<?> request) throws TenantNotFoundException {
        return Objects.requireNonNull(request, "request must not be null").getUserPrincipal().map(Principal::getName).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved because " + HttpAttributes.PRINCIPAL + " attribute was not found"));
    }

    @Override
    @NonNull
    @Deprecated(forRemoval=true, since="5.5.0")
    public Serializable resolveTenantIdentifier() {
        return this.resolveTenantId();
    }

    @Override
    @NonNull
    @Deprecated(forRemoval=true, since="5.5.0")
    public Serializable resolveTenantIdentifier(@NonNull HttpRequest<?> request) throws TenantNotFoundException {
        return this.resolveTenantId(request);
    }
}

