/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.writer;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.cookie.SameSite;
import io.micronaut.multitenancy.writer.CookieTenantWriterConfiguration;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

@ConfigurationProperties(value="micronaut.multitenancy.tenantwriter.cookie")
public class CookieTenantWriterConfigurationProperties
implements CookieTenantWriterConfiguration {
    public static final String PREFIX = "micronaut.multitenancy.tenantwriter.cookie";
    public static final boolean DEFAULT_ENABLED = false;
    public static final boolean DEFAULT_HTTPONLY = true;
    public static final String DEFAULT_COOKIENAME = "tenantId";
    public static final String DEFAULT_COOKIEPATH = "/";
    @NonNull
    private String cookiename = "tenantId";
    @Nullable
    private String cookieDomain;
    @Nullable
    private String cookiePath = "/";
    @Nullable
    private SameSite sameSite;
    private Boolean cookieHttpOnly = true;
    private Boolean cookieSecure;
    private TemporalAmount cookieMaxAge;
    private boolean enabled = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCookiename(String cookiename) {
        this.cookiename = cookiename;
    }

    @Override
    @NonNull
    public String getCookiename() {
        return this.cookiename;
    }

    @NonNull
    public String getCookieName() {
        return this.cookiename;
    }

    public Optional<String> getCookieDomain() {
        return Optional.ofNullable(this.cookieDomain);
    }

    @Nullable
    public Optional<String> getCookiePath() {
        return Optional.ofNullable(this.cookiePath);
    }

    public Optional<Boolean> isCookieHttpOnly() {
        return Optional.ofNullable(this.cookieHttpOnly);
    }

    public Optional<Boolean> isCookieSecure() {
        return Optional.ofNullable(this.cookieSecure);
    }

    public Optional<TemporalAmount> getCookieMaxAge() {
        return Optional.ofNullable(this.cookieMaxAge);
    }

    public void setCookieDomain(@Nullable String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setCookiePath(@Nullable String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public void setCookieMaxAge(TemporalAmount cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public Optional<SameSite> getCookieSameSite() {
        return Optional.ofNullable(this.sameSite);
    }

    public void setCookieSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
    }
}

