/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.multitenancy.Tenant;
import jakarta.inject.Singleton;
import java.util.Optional;

@Internal
@Singleton
final class TenantTypedRequestArgumentBinder
implements TypedRequestArgumentBinder<Tenant> {
    TenantTypedRequestArgumentBinder() {
    }

    public Argument<Tenant> argumentType() {
        return Argument.of(Tenant.class);
    }

    public ArgumentBinder.BindingResult<Tenant> bind(ArgumentConversionContext<Tenant> context, HttpRequest<?> source) {
        if (!source.getAttributes().contains("tenantIdentifier")) {
            return ArgumentBinder.BindingResult.UNSATISFIED;
        }
        Optional tenantOptional = source.getAttribute((CharSequence)"tenantIdentifier", String.class);
        if (tenantOptional.isEmpty()) {
            return ArgumentBinder.BindingResult.EMPTY;
        }
        return () -> Optional.of(tenantOptional::get);
    }
}

