/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.FixedTenantResolverConfiguration;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import jakarta.inject.Singleton;
import java.io.Serializable;

@Requirements(value={@Requires(beans={FixedTenantResolverConfiguration.class}), @Requires(property="micronaut.multitenancy.tenantresolver.fixed.enabled", value="true", defaultValue="false")})
@Singleton
public class FixedTenantResolver
implements TenantResolver {
    private final FixedTenantResolverConfiguration fixedTenantResolverConfiguration;

    public FixedTenantResolver(FixedTenantResolverConfiguration fixedTenantResolverConfiguration) {
        this.fixedTenantResolverConfiguration = fixedTenantResolverConfiguration;
    }

    @Override
    @Deprecated(forRemoval=true, since="5.5.0")
    @NonNull
    public Serializable resolveTenantIdentifier() throws TenantNotFoundException {
        return this.resolveTenantId();
    }

    @Override
    @NonNull
    public String resolveTenantId() throws TenantNotFoundException {
        String tenantId = this.fixedTenantResolverConfiguration.getTenantId();
        if (tenantId == null) {
            throw new TenantNotFoundException("TenantId could not be resolved. tenantId is null at FixedTenantResolver");
        }
        return tenantId;
    }
}

