/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.expression;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import jakarta.inject.Singleton;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
@Requires(beans={TenantResolver.class})
public final class TenantEvaluationContext {
    private static final Logger LOG = LoggerFactory.getLogger(TenantEvaluationContext.class);
    private final TenantResolver tenantResolver;

    public TenantEvaluationContext(TenantResolver tenantResolver) {
        this.tenantResolver = tenantResolver;
    }

    @Nullable
    public String getTenantId() {
        try {
            Serializable tenant = this.tenantResolver.resolveTenantIdentifier();
            if (tenant instanceof CharSequence) {
                CharSequence charSequenceTenant = (CharSequence)((Object)tenant);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved tenant: {}", (Object)tenant);
                }
                return charSequenceTenant.toString();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tenant not resolvable to a String: {}", (Object)tenant);
            }
            return null;
        }
        catch (TenantNotFoundException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tenant not found: {}", (Object)ex.getMessage());
            }
            return null;
        }
    }
}

