/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.filter.TenantResolverExistsCondition;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerFilter(patternStyle=FilterPatternStyle.REGEX, value={"${micronaut.multitenancy.filter.regex-pattern:^.*$}"})
@Internal
@Requires(condition=TenantResolverExistsCondition.class)
final class TenantResolverFilter
implements Ordered {
    public static final String ATTRIBUTE_TENANT = "tenantIdentifier";
    private static final Logger LOG = LoggerFactory.getLogger(TenantResolverFilter.class);
    @Nullable
    private final HttpRequestTenantResolver httpRequestTenantResolver;
    @Nullable
    private final TenantResolver tenantResolver;

    TenantResolverFilter(@Nullable HttpRequestTenantResolver httpRequestTenantResolver, @Nullable TenantResolver tenantResolver) {
        this.httpRequestTenantResolver = httpRequestTenantResolver;
        this.tenantResolver = tenantResolver;
    }

    public int getOrder() {
        return ServerFilterPhase.SECURITY.before();
    }

    @RequestFilter
    void filter(HttpRequest<?> request) {
        Optional<String> tenantOptional = this.resolveTenant(request);
        if (tenantOptional.isEmpty()) {
            tenantOptional = this.resolveTenant();
        }
        tenantOptional.ifPresent(tenant -> request.setAttribute((CharSequence)ATTRIBUTE_TENANT, tenant));
    }

    private Optional<String> resolveTenant(HttpRequest<?> request) {
        if (this.httpRequestTenantResolver == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.httpRequestTenantResolver.resolveTenantId(request));
        }
        catch (TenantNotFoundException ex) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Tenant could not be resolved");
            }
            return Optional.empty();
        }
    }

    private Optional<String> resolveTenant() {
        if (this.tenantResolver == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.tenantResolver.resolveTenantId());
        }
        catch (TenantNotFoundException ex) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Tenant could not be resolved");
            }
            return Optional.empty();
        }
    }
}

