/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractSubdomainTenantResolver
implements TenantResolver,
HttpRequestTenantResolver {
    private static final String COLON_SLASH_SLASH = "://";
    protected HttpHostResolver httpHostResolver;

    protected AbstractSubdomainTenantResolver(HttpHostResolver httpHostResolver) {
        this.httpHostResolver = httpHostResolver;
    }

    @Override
    @NonNull
    public String resolveTenantId() {
        Optional current = ServerRequestContext.currentRequest();
        return current.map(this::resolveTenantId).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved outside a web request"));
    }

    @Override
    @NonNull
    public String resolveTenantId(@NonNull HttpRequest<?> request) throws TenantNotFoundException {
        String host = this.httpHostResolver.resolve(Objects.requireNonNull(request, "request must not be null"));
        return this.resolveSubdomain(this.hostWithoutProtocol(host)).toString();
    }

    @Override
    @NonNull
    @Deprecated(forRemoval=true, since="5.5.0")
    public Serializable resolveTenantIdentifier() {
        return this.resolveTenantId();
    }

    @Override
    @NonNull
    @Deprecated(forRemoval=true, since="5.5.0")
    public Serializable resolveTenantIdentifier(@NonNull HttpRequest<?> request) throws TenantNotFoundException {
        return this.resolveTenantId(request);
    }

    @NonNull
    protected abstract Serializable resolveSubdomain(@NonNull String var1);

    @NonNull
    private String hostWithoutProtocol(@NonNull String host) {
        int index = host.indexOf(COLON_SLASH_SLASH);
        return index < 0 ? host : host.substring(index + COLON_SLASH_SLASH.length());
    }
}

